﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" EnableEventValidation="false" AutoEventWireup="true" CodeBehind="Products.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Masters.Product.Products" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ScriptManager runat="server">
        <Services>
            <asp:ServiceReference Path="~/Admin/WebService/AzvicService.asmx" />
        </Services>
    </asp:ScriptManager>
 
    <div class="pageheader">
        <h2>
            <i class="fa fa-list"></i>Products
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Products</li>
            </ol>
        </div>
    </div>

    <div class="main searchFields">
        <div class="row">
            <div class="pull-right">
                <asp:HyperLink ID="lnkAddProduct" runat="server" CssClass="btn-lg btn btn-primary loading"
                    NavigateUrl="~/Admin/Masters/Product/EditProduct.aspx">New Product</asp:HyperLink>
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                Search Word :
            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtSearch" runat="server" CssClass="textbox w100p" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>
    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Products</h1>
            <div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
            &nbsp; &nbsp;
            <div class="pull-right" style="padding-right: 15px;">
                <input type="button" onclick="OpenUpload();" class="btn-lg btn btn-primary" value="Upload Inventory" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdProducts" AllowPaging="true" PageSize="30" CssClass="table"
                    Width="98%" GridLines="Both" AutoGenerateColumns="false" OnPageIndexChanging="grdProducts_PageIndexChanging"
                    OnRowDataBound="grdProducts_RowDataBound">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Product Name" DataField="ProductName" />
                        <asp:TemplateField HeaderText="Category">
                            <ItemTemplate>
                                <asp:Label ID="lblCategoryName" runat="server" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Brand">
                            <ItemTemplate>
                                <asp:Label ID="lblBrandName" runat="server" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <%--<asp:TemplateField HeaderText="Color">
                            <ItemTemplate>
                                <asp:Label ID="lblColorName" runat="server" />
                            </ItemTemplate>
                        </asp:TemplateField>--%>
                        <asp:TemplateField HeaderText="Size">
                            <ItemTemplate>
                                <asp:Label ID="lblSizeName" runat="server" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Product Code" DataField="ProductCode" />
                        <asp:BoundField HeaderText="UnitPrice" DataField="UnitPrice" DataFormatString="{0:C}" />
                        <%--<asp:BoundField HeaderText="Actual Stock" DataField="ActualStock" />--%>
                        <asp:TemplateField HeaderText="Actual Stock" ItemStyle-CssClass="ActualStock">
                            <ItemTemplate>
                                <asp:TextBox runat="server" Text='<%# Eval("ActualStock") %>' data-ProductID='<%# Eval("UniqueID") %>' Style="min-width: 100px !important; width: 100px;" onfocus="OnEditStart(this);" onblur="OnEditComplete(this);" onkeypress="return IsNumeric(event)" Enabled='<%# Eval("IsSales") %>' />
                                <img src="../../Images/Loading_cafe.gif" style="display: none;" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Reserve Stock" DataField="ReserveStock" />
                         <asp:TemplateField HeaderText="Sequence Number" ItemStyle-CssClass="SequenceNo">
                            <ItemTemplate>
                                <asp:TextBox ID="txtSequenceNumber" runat="server" Text='<%# Eval("SequenceNo") %>' data-ProductID='<%# Eval("UniqueID") %>' Style="min-width: 100px !important; width: 100px;" onfocus="OnEditSequenceStart(this);" onblur="OnEditSequenceComplete(this);" onkeypress="return IsNumeric(event)" />
                                <img src="../../Images/Loading_cafe.gif" style="display: none;" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <%--<asp:TemplateField HeaderText="Best Sale">
                            <ItemTemplate>
                                <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsBestSales").ToString()) ? "Yes" : "No"%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Is New">
                            <ItemTemplate>
                                <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsNew").ToString()) ? "Yes" : "No"%>
                            </ItemTemplate>
                        </asp:TemplateField>--%>
                        <asp:TemplateField HeaderText="Invetory Tracking">
                            <ItemTemplate>
                                <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsSales").ToString()) ? "Active" : "Inactive"%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <%--<asp:TemplateField HeaderText="Status">
                            <ItemTemplate>
                                <%#bool.Parse(DataBinder.Eval(Container.DataItem, "IsActive").ToString()) ? "Active" : "Inactive"%>
                            </ItemTemplate>
                        </asp:TemplateField>--%>
                        <asp:HyperLinkField DataNavigateUrlFields="UniqueID" DataNavigateUrlFormatString="~/Admin/Masters/Product/EditProduct.aspx?UniqueID={0}"
                            Text="Edit" HeaderText="Control" />
                    </Columns>
                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                        Position="TopAndBottom" />
                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                        Font-Bold="true" Font-Size="Medium" />

                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-row" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>
    <div class="modal fade" id="divUploadFile" tabindex="-1" role="dialog" aria-labelledby="Upload Excel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H4">Upload Excel - Inventory Update</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        Please upload the formatted Inventory Excel document. If you are not sure about the formatting, please download a formatted document from the link below.
                    </div>
                    <br />
                    <br />
                    <div class="row">
                        <div class="col-md-6">
                            Select File to upload
                        </div>
                        <div class="col-md-6">
                            <asp:FileUpload runat="server" ID="uplInventoryExcel" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <a href="../../Files/Inventory.xlsx">Download Standard Format</a>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <%--<button type="button" class="btn btn-danger" id="btnYes" onclick="ConfirmDelete();">Upload </button>--%>
                    <asp:Button runat="server" ID="btnUploadInventoryExcel" OnClientClick="return CheckSelection();" OnClick="btnUploadInventoryExcel_Click" CssClass="btn btn-danger" Text="Upload Inventory" />
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divInventoryConfirmation" tabindex="-1" role="dialog" aria-labelledby="Upload Excel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H1">Confirm Update</h4>
                </div>
                <div class="modal-body">
                    <div class="row text-center">
                        Please check the inventory and confirm update by clicking the confirm button.
                    </div><br />
                    <div class="row text-center">
                       <asp:Label runat="server" ID="lblError" ForeColor="Red" Font-Bold="true" Visible="false" />
                    </div><br />
                    <div class="row">
                        <div class="table-responsive">
                            <asp:GridView runat="server" CssClass="table" ID="gvInventory" GridLines="None" OnRowDataBound="gvInventory_RowDataBound" AutoGenerateColumns="false" DataKeyNames="UniqueID">
                                <Columns>
                                    <asp:TemplateField ControlStyle-CssClass="hidden">
                                        <ItemTemplate>
                                            <asp:HiddenField runat="server" ID="hdnProductID" Value='<%# Eval("UniqueID") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="ProductName" HeaderText="Product Name" />
                                    <asp:TemplateField HeaderText="Size">
                                        <ItemTemplate>
                                            <asp:Label runat="server" ID="lblProductSize" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Brand">
                                        <ItemTemplate>
                                            <asp:Label runat="server" ID="lblProductBrand" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Unit Price">
                                        <ItemTemplate>
                                            <asp:TextBox runat="server" ID="txtUnitPrice" CssClass="smallTextBox" onkeypress="return IsDecimal(event)" Text='<%# Eval("UnitPrice") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Happy Hour Price">
                                        <ItemTemplate>
                                            <asp:TextBox runat="server" ID="txtHappyHourPrice" CssClass="smallTextBox" onkeypress="return IsDecimal(event)" Text='<%# Eval("HappyHourPrice") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Actual Stock">
                                        <ItemTemplate>
                                            <asp:TextBox runat="server" ID="txtActualStock" CssClass="smallTextBox" onkeypress="return IsNumeric(event)" Text='<%# Eval("ActualStock") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Reserve Stock">
                                        <ItemTemplate>
                                            <asp:TextBox runat="server" ID="txtReserveStock" CssClass="smallTextBox" onkeypress="return IsNumeric(event)" Text='<%# Eval("ReserveStock") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Low Stock Indication">
                                        <ItemTemplate>
                                            <asp:TextBox runat="server" ID="txtLowStockIndication" CssClass="smallTextBox" onkeypress="return IsNumeric(event)" Text='<%# Eval("LowStockIndication") %>' />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                                <HeaderStyle CssClass="tbl-header" />
                                <RowStyle CssClass="tbl-row" />
                                <AlternatingRowStyle CssClass="tbl-row" />
                                <EmptyDataRowStyle />
                                <EmptyDataTemplate>
                                    No valid Inventory data is present in the excel. Please verify whether the format is in accordance with the standard format.
                                </EmptyDataTemplate>
                            </asp:GridView>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button runat="server" ID="btnConfirmUpdate" OnClick="btnConfirmUpdate_Click" CssClass="btn btn-danger" Text="Confirm Changes" />
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>


</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>



        var initialValue = '';


        function OnEditSequenceComplete(txtbox) {
            var FinalValue = $(txtbox).val();
            if (FinalValue != '') {
                if (initialValue != FinalValue) {
                    //Update the Product Quantity
                    $(txtbox).siblings('img').show();
                    var ProductID = $(txtbox).attr('data-ProductID');
                    var Qty = $(txtbox).parent('td').siblings('.ActualStock').find('input').val();
                    AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.UpdateProduct(ProductID, Qty,FinalValue, OnSuccessUpdate, OnError);
                }
            }
            else {
                $(txtbox).val(initialValue);
            }
            $(txtbox).css('border', '1px solid rgb(226,226,226)');
        }
        function OnEditSequenceStart(txtbox) {
            initialValue = $(txtbox).val();
            $(txtbox).css('border', '1px double rgba(192, 0, 0, 0.94)');
        }

        function OnEditComplete(txtbox) {
            var FinalValue = $(txtbox).val();
            if (FinalValue != '') {
                if (initialValue != FinalValue) {
                    //Update the Product Quantity
                    $(txtbox).siblings('img').show();
                    var ProductID = $(txtbox).attr('data-ProductID');
                    var SequenceNo = $(txtbox).parent('td').siblings('.SequenceNo').find('input').val();
                    AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.UpdateProduct(ProductID, FinalValue,SequenceNo, OnSuccessUpdate, OnError);
                }
            }
            else {
                $(txtbox).val(initialValue);
            }
            $(txtbox).css('border', '1px solid rgb(226,226,226)');
        }

        function OnEditStart(txtbox) {
            initialValue = $(txtbox).val();
            $(txtbox).css('border', '1px double rgba(192, 0, 0, 0.94)');
        }

        function OnSuccessUpdate(result) {
            $('#<%= grdProducts.ClientID %> tr td input[data-productID=' + result.UniqueID + ']').siblings('img').hide();
        }
        function OnError(result) {
            ShowAlert(result.message, 'Error in updating the values during this time. Please try again later.');
        }

        function OpenUpload() {
            $('#divUploadFile').modal('show');
        }
        function CheckSelection() {
            if ($('#<%= uplInventoryExcel.ClientID %>').val() != '') {
                return true;
            }
            else {
                validationMsgTop('#<%= uplInventoryExcel.ClientID %>', 'Please select a file to upload');
                return false;
            }
        }

        function OpenConfirmation() {
            $('#divInventoryConfirmation').modal({ keyboard: false, backdrop: 'static', show: 'true' });
        }

    </script>
</asp:Content>
